
#include <pspkernel.h>
//ʾͷļ
#include <pspdisplay.h>
#include <pspdebug.h> 

//Ļ
#define SCREEN_WIDTH 		480
//Ļ߶
#define SCREEN_HEIGHT 		272

//ɨߴС
#define	SCAN_LINE_SIZE 		512   	// 512 units (either 16bits or 32bits per scanline
//ARGBɫλ꺯
#define ARGB(a, r, g, b)	(a<<24|b<<16|g<<8|r)

// app name and version number
PSP_MODULE_INFO("Subject-03", 0, 1, 1);

// optional
PSP_MAIN_THREAD_ATTR(THREAD_ATTR_USER);

//printf,򻯵Դӡд
#define printf pspDebugScreenPrintf 

//Ƴѭı
int done = 0;

// VRAM actually starts from 0x04000000 but need to OR with 0x40000000 to prevent 
// unpredictable behaviours due to caching
u32* pVRAM = (u32*)(0x04000000+0x40000000);	


// Exit callback
int exit_callback(int arg1, int arg2, void *common)
{
	done = 1;
	return 0;
}


// Callback thread
int CallbackThread(SceSize args, void *argp)
{
	int cbid;

	cbid = sceKernelCreateCallback("Exit Callback", exit_callback, NULL);
	sceKernelRegisterExitCallback(cbid);

	sceKernelSleepThreadCB();

	return 0;
}


// Sets up the callback thread and returns its thread id
int SetupCallbacks(void)
{
	int thid = 0;

    thid = sceKernelCreateThread("update_thread", CallbackThread, 0x11, 0xFA0, 0, 0);
    if(thid >= 0) 
	{
		sceKernelStartThread(thid, 0, 0);
    }

    return thid;
} 

//ָصʾɫ
// Plot a single pixel on screen
void Plot(int x, int y, u32 color)
{
	u32* p = pVRAM + y * SCAN_LINE_SIZE + x;
	*p = color;
}

//ָɫ
// Fill a rectangular area with a specific color
void FillRect(int x, int y, int width, int height, u32 color)
{
	// get starting addr of the 1st pixel
	u32* p = pVRAM + y * SCAN_LINE_SIZE + x;
	int i, j;
	for (j=0;j<height;j++)
	{
		for (i=0;i<width;i++)	// plot one row
		{
			*(p+i) = color;
		}
		
		p += SCAN_LINE_SIZE;	// move pointer to the next row
	}
}


// Taken from: http://forums.qj.net/showthread.php?t=19422
// Original programmer: Yeldarb
void WriteByte(int fd, unsigned char data) 
{
	sceIoWrite(fd, &data, 1);
}

//,ͼƬΪ.tgaʽڼĿ¼
void ScreenShot()
{
	const char tgaHeader[] = {0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0};
	const int width = SCREEN_WIDTH;
	const int lineWidth = SCAN_LINE_SIZE;
	const int height = SCREEN_HEIGHT;
	unsigned char lineBuffer[width*4];
	u32* vram = pVRAM;
	int x, y;
	int fd = sceIoOpen("ms0:/screenshot.tga", PSP_O_CREAT | PSP_O_TRUNC | PSP_O_WRONLY, 0777);
	if (!fd) return;
	sceIoWrite(fd, tgaHeader, sizeof(tgaHeader));
	WriteByte(fd, width & 0xff);
	WriteByte(fd, width >> 8);
	WriteByte(fd, height & 0xff);
	WriteByte(fd, height >> 8);
	WriteByte(fd, 24);
	WriteByte(fd, 0);
	for (y = height - 1; y >= 0; y--) {
		for (x = 0; x < width; x++) {
			u32 color = vram[y * lineWidth + x];
			unsigned char red = color & 0xff;
			unsigned char green = (color >> 8) & 0xff;
			unsigned char blue = (color >> 16) & 0xff;
			lineBuffer[3*x] = blue;
			lineBuffer[3*x+1] = green;
			lineBuffer[3*x+2] = red;
		}
		sceIoWrite(fd, lineBuffer, width * 3);
	}
	sceIoClose(fd);
}

int mario_color[14]={0x00000000,0xff000000,0xffffffff,0xff003399,0xff0033cc,0xff3333ff,
					0xff6666dd,0xffcc6633,0xff66ccff,0xff993333,0xffff996,
					0xff33ccff,0xff0066cc,0xff3399ff};
int mario_data[16][16]={
			  {0,0,0,0,0,1,1,1,1,1,0,0,1,1,1,0},
			  {0,0,0,0,1,3,3,4,5,5,1,1,2,2,2,1},
			  {0,0,0,1,3,3,4,4,4,4,4,4,1,2,2,1},
			  {0,0,0,1,1,1,6,6,1,6,1,1,1,7,1,0},
			  {0,0,1,8,8,1,1,6,1,8,8,8,8,7,1,0},
			  {0,0,1,6,6,1,1,8,8,1,6,6,6,7,1,0},
			  {0,0,0,1,1,6,6,8,1,1,1,1,1,1,0,0},
			  {0,0,0,0,1,1,6,6,6,6,6,6,7,1,0,0},
			  {0,0,1,9,10,7,3,4,9,7,1,7,1,0,0,0},
			  {0,1,1,1,9,10,7,3,4,9,7,1,1,1,1,0},
			  {1,2,2,2,1,9,9,1,2,5,5,2,1,11,12,1},
			  {1,2,2,2,1,9,1,4,4,4,4,1,11,12,12,1},
			  {0,1,1,1,1,1,4,3,3,3,3,1,13,12,1,0},
			  {1,12,12,13,1,4,3,3,3,1,1,1,13,12,1,0},
			  {1,12,13,1,3,3,3,1,1,0,0,0,1,1,0,0},
			  {0,1,1,0,1,1,1,0,0,0,0,0,0,0,0,0}};

// The main loop
int main()
{ 
	//ȻpspDebugScreenPrintf,Ļʾ,ǵóʼ
	pspDebugScreenInit();	// do this so that we can use pspDebugScreenPrintf
	SetupCallbacks(); 
	
	//Ļʾģʽ,0:ɫʹABGRʽ
	// mode 0, pixel format: ABGR
	sceDisplaySetMode(0, SCREEN_WIDTH, SCREEN_HEIGHT);	
	

	while (!done)
	{
	/*
		// plot some pixels
		Plot(50, 20, ARGB(255,255,0,0));	// a red pixel
		Plot(100, 20, ARGB(255,0,255,0));	// a green pixel
		Plot(300, 20, ARGB(255,0,0,255));	// a blue pixel
		
		// fill some color rectangles
		FillRect(50, 100, 20, 20, ARGB(0,255,0,0));		// a red rectangle
		FillRect(100, 150, 20, 20, ARGB(255,0,255,0));	// a green rectangle
		FillRect(300, 200, 20, 20, ARGB(255,0,0,255));	// a blue rectangle
		*/
		int offset = 30;
		int mario_width = sizeof(mario_data[0])/sizeof(int);
		int mario_height = sizeof(mario_data)/sizeof(mario_data[0]);
		int i,j;
		for(i = 0; i < mario_height; i++) {
			for(j = 0; j < mario_width; j++) {
				if(mario_data[i][j] != 0) {
					FillRect(10 * j + offset, 10 * i + offset, 10, 10, mario_color[mario_data[i][j]]);
				}
			}
		}
		// if we don't have a small pause at all, PSP may no response to the "HOME" button click
		sceDisplayWaitVblankStart();
	}
	
	ScreenShot();
	
	sceKernelExitGame();
	return 0; 
} 
